<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <!-- Least Squares Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis Vyrovnání metodou nejmenších čtverců</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <xsl:for-each select="AdjustmentNet">
                                <center>
                                    <!-- Report Title -->
                                    <h2 lang="en">Výpis Vyrovnání metodou nejmenších čtverců Předběžný</h2>
                                    <p lang="en">
                                        Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                        Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                    </p>
                                </center>
                                <p lang="en" style="text-align:center;font-size:80%">
                                    <strong>Aktivní geografický systém:&#xa0;</strong>
                                    &#xa0; <xsl:value-of select="//@coordinateSystemName"/>
                                    &#xa0; <xsl:value-of select="//@coordinateSystemDescription"/>
                                    <xsl:if test="//@linearUnits = 'I'">, stopy</xsl:if>
                                    <xsl:if test="//@linearUnits = 'F'">, Survey stopy</xsl:if>
                                    <xsl:if test="//@linearUnits = 'M'">, metry</xsl:if>
                                </p>
                                <hr/>
                                <xsl:for-each select="GenFileReport">
                                    <center>
                                        <h4>Přípravné uzavření trasy dle pravidel Compass</h4>
                                    </center>
                                    <hr size="1px"/>
                                    <xsl:for-each select="GenFileTraverseList">
                                        <xsl:for-each select="Traverse">
                                            <table class="margin" cellpadding="1" cellspacing="1" width="35%">
                                                <tbody>
                                                    <tr>
                                                        <th align="left" nowrap="nowrap">VÝPIS PŘÍPRAVNÉHO UZAVŘENÍ TRASY&#xa0;</th>
                                                    </tr>
                                                    <tr>
                                                        <th align="left" nowrap="nowrap">PŘÍPRAVNÁ DÉLKOVÁ CHYBA UZAVŘENÍ JE &#xa0;</th>
                                                        <td align="left" nowrap="nowrap">
                                                            <xsl:value-of select="cif:distanceFormat(number(@linearClosureError))"/>
                                                        </td>
                                                        <th align="left" nowrap="nowrap">PŘESNOST JE 1/ &#xa0;</th>
                                                        <td align="left" nowrap="nowrap">
                                                            <xsl:value-of select="cif:distanceFormat(number(@precision))"/>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                <colgroup span="3">
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                </colgroup>
                                                <thead style="display:table-header-group">
                                                    <tr>
                                                        <th class="underline" lang="en" align="left">Stanice</th>
                                                        <th class="underline" lang="en" align="right">Y</th>
                                                        <th class="underline" lang="en" align="right">X</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <xsl:for-each select="TraverseList">
                                                        <tr>
                                                            <td align="left">
                                                                <xsl:value-of select="@stationName"/>
                                                            </td>
                                                            <td align="right">
                                                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                                            </td>
                                                            <td align="right">
                                                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                                            </td>
                                                        </tr>
                                                    </xsl:for-each>
                                                </tbody>
                                            </table>
                                        </xsl:for-each>
                                        <tr style="line-height:50%">
                                            <td>&#xa0;</td>
                                        </tr>
                                        <xsl:for-each select="AdjustedHorizontal">
                                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                <tbody>
                                                    <tr>
                                                        <th align="left" nowrap="nowrap">PŘÍPRAVNÉ GENEROVANÉ SOUŘADNICE&#xa0;</th>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                <colgroup span="3">
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                </colgroup>
                                                <thead style="display:table-header-group">
                                                    <tr>
                                                        <th class="underline" lang="en" align="left">Stanice</th>
                                                        <th class="underline" lang="en" align="right">Y</th>
                                                        <th class="underline" lang="en" align="right">X</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <xsl:for-each select="AdjustedHorizontalList">
                                                        <tr>
                                                            <td align="left">
                                                                <xsl:value-of select="@stationName"/>
                                                            </td>
                                                            <td align="right">
                                                                <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                                                            </td>
                                                            <td align="right">
                                                                <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                                                            </td>
                                                        </tr>
                                                    </xsl:for-each>
                                                </tbody>
                                            </table>
                                        </xsl:for-each>
                                        <tr style="line-height:50%">
                                            <td>&#xa0;</td>
                                        </tr>
                                        <xsl:for-each select="DistanceResidual">
                                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                <tbody>
                                                    <tr>
                                                        <th align="left" nowrap="nowrap">PŘÍPRAVNÉ DÉLKY ZBYTKY&#xa0;</th>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                <colgroup span="3">
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                </colgroup>
                                                <thead style="display:table-header-group">
                                                    <tr>
                                                        <th class="underline" lang="en" align="left">
                                                            Ze<br/>stanice
                                                        </th>
                                                        <th class="underline" lang="en" align="left">
                                                            Do<br/>stanice
                                                        </th>
                                                        <th class="underline" lang="en" align="right">Zbytek</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <xsl:for-each select="DistanceResidualList">
                                                        <tr>
                                                            <td align="left">
                                                                <xsl:value-of select="@fromStation"/>
                                                            </td>
                                                            <td align="left">
                                                                <xsl:value-of select="@toStation"/>
                                                            </td>
                                                            <td align="right">
                                                                <xsl:choose>
                                                                    <xsl:when test="@residual='*******'">
                                                                        <xsl:value-of select="@residual"/>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </td>
                                                        </tr>
                                                    </xsl:for-each>
                                                </tbody>
                                            </table>
                                        </xsl:for-each>
                                        <tr style="line-height:50%">
                                            <td>&#xa0;</td>
                                        </tr>
                                        <xsl:for-each select="AngleResidual">
                                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                <tbody>
                                                    <tr>
                                                        <th align="left" nowrap="nowrap">PŘÍPRAVNÉ ÚHLY ZBYTKOVÉ&#xa0;</th>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                <colgroup span="4">
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                    <col width="5%"/>
                                                </colgroup>
                                                <thead style="display:table-header-group">
                                                    <tr>
                                                        <th class="underline" lang="en" align="left">
                                                            Zpětná<br/>stanice
                                                        </th>
                                                        <th class="underline" lang="en" align="left">
                                                            Nastavení<br/>stanice
                                                        </th>
                                                        <th class="underline" lang="en" align="left">
                                                            Dopředná<br/>stanice
                                                        </th>
                                                        <th class="underline" lang="en" align="right">Zbytek</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <xsl:for-each select="AngleResidualList">
                                                        <tr>
                                                            <td align="left">
                                                                <xsl:value-of select="@backSightStation"/>
                                                            </td>
                                                            <td align="left">
                                                                <xsl:value-of select="@setupStation"/>
                                                            </td>
                                                            <td align="left">
                                                                <xsl:value-of select="@foreSightStation"/>
                                                            </td>
                                                            <td align="right">
                                                                <xsl:choose>
                                                                    <xsl:when test="@residual='*******'">
                                                                        <xsl:value-of select="@residual"/>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <xsl:value-of select="cif:distanceFormat(number(@residual))"/>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </td>
                                                        </tr>
                                                    </xsl:for-each>
                                                </tbody>
                                            </table>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
       </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
               Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje síť měření s provedeným vyrovnáním. 
	</p>

<p class="normal1">  V Průzkumníku projektu se ujistěte, že vpravo od Vyrovnání svítí zelená značka (ukazuje kompletní provedení). Pravým kliknutím na Vyrovnání vyberte Výsledky vyrovnání pro odpovídající výpis. </p>
            <p class="normal1">Jakmile je otevřený Průzkumník výpisů, zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
    </xsl:stylesheet>
